



export class MasterDataWidget {
	
	tpl = `
		<div class="page-header">
			<h1>Stamgegevens</h1>
		</div>
		
		<div ez-for="menuItems" ez-item="m">
			<div class="col-12 col-sm-4 col-lg-3 setting-menu-tag-container">
				<h2>{{m.label}}</h2>
				
				<ul ez-for="m.items" ez-item="mi">
					<li><a href="{{mi.url}}">{{mi.label}}</a></li>
				</ul>
			</div>
		<?div>
		
	`;
	
	menuItems = [];
	
	
	init(e) {
		if (toolboxConfig.admin == false) {
			gotoRoute( '/' );
			return;
		}
		
		this.initMenu();
		
		let ezTpl = new EzTemplate( e );
		ezTpl.loadHtml( this.tpl );
		ezTpl.setVar('menuItems', this.menuItems);
		ezTpl.render();
	}
	
	
	initMenu() {
		this.menuItems.push({
			'label': 'Instellingen',
			'code': 'settings',
			'items': [
				{ 'url': '/masterdata/appsettings/', 'label': 'App instellingen' }
				, { 'url': '/masterdata/users/', 'label': 'Gebruikersbeheer' }
				, { 'url': '/masterdata/groups/', 'label': 'Groepen' }
			]
		});
		
		/*
		this.menuItems.push({
			'label': 'Contracten',
			'code': 'contracts',
			'items': [
				{ url: '/masterdata/contracts/types/', 'label': 'Contract typen' }
			]
		});*/
		
		
		this.menuItems.push({
			'label': 'E-mail',
			'code': 'email',
			'items': [
				{ url: '/masterdata/email/settings/', 'label': 'E-mail instellingen' }
				, { url: '/email/templates/', 'label': 'E-mail templates' }
			]
		});

		/*
		this.menuItems.push({
			'label': 'Sales',
			'code': 'sales',
			'items': [
				{ url: '/masterdata/email/settings/', 'label': 'E-mail instellingen' }
				, { url: '/masterdata/sales/settings/', 'label': 'Sales Instellingen' }
				, { url: '/masterdata/sales/vat/', 'label': 'Btw tarieven' }
				, { url: '/masterdata/sales/article/', 'label': 'Artikelen' }
				, { url: '/masterdata/sales/articlegroup/', 'label': 'Artikelgroepen' }
				, { url: '/masterdata/sales/slotplan/', 'label': 'Slot plannen' }
				, { url: '/masterdata/sales/dayprice/', 'label': 'Dagprijzen' }
			]
		});*/

		this.menuItems.push({
			'label': 'Overig',
			'code': 'misc',
			'items': [
				{ url: '/masterdata/activity/', 'label': 'Logboek' }
				, { url: '/masterdata/license/', 'label': 'Registratie' }
				, { url: '/masterdata/websessions/', 'label': 'Gebruiker sessies' }
		]});
		
		this.menuItems = apply_filter( 'MasterData.menuItems', this.menuItems );
	}
	
	
}

